/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.ai.goal;

import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.base.AnimationAbstractGoal;
import com.eeeab.eeeabsmobs.sever.entity.impl.namelessguardian.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.github.alexthe666.citadel.animation.Animation;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class GuardianPounceAttackGoal
extends AnimationAbstractGoal<EntityNamelessGuardian> {
    private final EntityNamelessGuardian entity;
    private Vec3 pounceVec = Vec3.f_82478_;
    private final float speedMultiplier;
    private boolean isPowered;
    private float madnessSpeedMultiplier;
    private int consecutive;

    public GuardianPounceAttackGoal(EntityNamelessGuardian entity, float speedMultiplier) {
        super(entity);
        this.entity = entity;
        this.speedMultiplier = speedMultiplier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.isPowered = this.entity.m_7090_();
        this.madnessSpeedMultiplier = this.speedMultiplier;
        if (this.isPowered) {
            this.madnessSpeedMultiplier += 0.5f;
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.madnessSpeedMultiplier = 0.0f;
        this.isPowered = false;
        this.consecutive = 0;
    }

    @Override
    protected boolean test(Animation animation) {
        return animation == EntityNamelessGuardian.POUNCE_ATTACK_ANIMATION_2 || animation == EntityNamelessGuardian.POUNCE_ATTACK_ANIMATION_1 || animation == EntityNamelessGuardian.POUNCE_ATTACK_ANIMATION_3;
    }

    public void m_8037_() {
        float baseDamageMultiplier;
        LivingEntity target = this.entity.m_5448_();
        double moveSpeed = this.entity.m_21133_(Attributes.f_22279_);
        float f = baseDamageMultiplier = this.isPowered ? 0.8f : 0.6f;
        if (this.entity.getAnimation() == EntityNamelessGuardian.POUNCE_ATTACK_ANIMATION_1) {
            int tick;
            int animationDuration = EntityNamelessGuardian.POUNCE_ATTACK_ANIMATION_1.getDuration();
            this.entity.m_20334_(0.0, this.entity.m_20096_() ? 0.0 : this.entity.m_20184_().m_7098_(), 0.0);
            if (target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
            }
            if ((tick = this.entity.getAnimationTick()) != 1 && tick >= animationDuration - 1) {
                if (target != null) {
                    this.pounceVec = GuardianPounceAttackGoal.findTargetPoint((Entity)this.entity, (Entity)target);
                    this.entity.playAnimation(EntityNamelessGuardian.POUNCE_ATTACK_ANIMATION_2);
                } else {
                    this.entity.playAnimation(EntityNamelessGuardian.POUNCE_ATTACK_ANIMATION_3);
                }
            }
        } else if (this.entity.getAnimation() == EntityNamelessGuardian.POUNCE_ATTACK_ANIMATION_2) {
            int keyFrame;
            int tick = this.entity.getAnimationTick();
            int n = keyFrame = this.isPowered ? 24 : 28;
            if (tick < keyFrame) {
                this.entity.m_20334_(this.pounceVec.f_82479_ * moveSpeed * (double)this.madnessSpeedMultiplier, -this.entity.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get()) * 5.0, this.pounceVec.f_82481_ * moveSpeed * (double)this.speedMultiplier);
                if (this.entity.m_21023_(MobEffects.f_19597_)) {
                    this.entity.m_21195_(MobEffects.f_19597_);
                }
                if (!this.entity.f_19853_.f_46443_ && ModEntityUtils.canMobDestroy((Entity)this.entity)) {
                    int maxz;
                    int maxy;
                    int maxx;
                    BlockPos max;
                    int minz;
                    int miny;
                    AABB bb = this.entity.m_20191_();
                    int minx = Mth.m_14107_((double)(bb.f_82288_ - 0.75));
                    BlockPos min = new BlockPos(minx, miny = Mth.m_14107_((double)(bb.f_82289_ + 0.0)), minz = Mth.m_14107_((double)(bb.f_82290_ - 0.75)));
                    if (this.entity.f_19853_.m_46832_(min, max = new BlockPos(maxx = Mth.m_14107_((double)(bb.f_82291_ + 0.75)), maxy = Mth.m_14107_((double)(bb.f_82292_ + 0.15)), maxz = Mth.m_14107_((double)(bb.f_82293_ + 0.75))))) {
                        BlockPos.m_121990_((BlockPos)min, (BlockPos)max).filter(pos -> ModEntityUtils.canDestroyBlock(this.entity.f_19853_, pos, (Entity)this.entity, 1.9f) && this.entity.f_19853_.m_7702_(pos) == null).forEach(pos -> this.entity.f_19853_.m_46961_(pos, true));
                    }
                }
                if (tick % 2 == 0) {
                    List<LivingEntity> livingEntities = this.entity.getNearByLivingEntities(3.0, 4.0, 3.0, 3.0);
                    for (LivingEntity hitEntity : livingEntities) {
                        Player player;
                        if (hitEntity == this.entity) continue;
                        float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, hitEntity);
                        float entityHitDistance = (float)Math.sqrt((hitEntity.m_20189_() - this.entity.m_20189_()) * (hitEntity.m_20189_() - this.entity.m_20189_()) + (hitEntity.m_20185_() - this.entity.m_20185_()) * (hitEntity.m_20185_() - this.entity.m_20185_())) - hitEntity.m_20205_() / 2.0f;
                        if (!(entityHitDistance <= 3.0f && entityRelativeAngle <= 60.0f && entityRelativeAngle >= -60.0f || entityRelativeAngle >= 300.0f) && !(entityRelativeAngle <= -300.0f)) continue;
                        this.entity.guardianHurtTarget(this.entity, hitEntity, 0.05f, 1.0f, baseDamageMultiplier, false, false);
                        double ratioX = Math.sin(this.entity.m_146908_() * ((float)Math.PI / 180));
                        double ratioZ = -Math.cos(this.entity.m_146908_() * ((float)Math.PI / 180));
                        ModEntityUtils.forceKnockBack(hitEntity, 1.5f, ratioX, ratioZ, 0.01f, false);
                        double duration = 1.5;
                        if (Difficulty.HARD.equals((Object)this.entity.f_19853_.m_46791_())) {
                            duration = 2.5;
                        }
                        if (hitEntity instanceof Player && !(player = (Player)hitEntity).m_7500_() && !player.m_21254_()) {
                            player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.VERTIGO_EFFECT.get(), (int)(duration * 20.0), 0, false, false, true));
                            continue;
                        }
                        if (hitEntity instanceof Player || hitEntity.m_21254_()) continue;
                        hitEntity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.VERTIGO_EFFECT.get(), (int)(duration * 20.0), 0, false, false, true));
                    }
                }
            } else if (tick == keyFrame) {
                this.entity.playAnimation(EntityNamelessGuardian.POUNCE_ATTACK_ANIMATION_3);
            }
        } else if (this.entity.getAnimation() == EntityNamelessGuardian.POUNCE_ATTACK_ANIMATION_3) {
            this.entity.m_20334_(0.0, this.entity.m_20184_().m_7098_(), 0.0);
            int maxExtraConsecutive = 2;
            if (this.consecutive < maxExtraConsecutive && this.entity.m_5448_() != null && this.entity.getAnimationTick() <= 6 && this.entity.getAnimationTick() > 1 && this.checkModeOrPreventTimeouts() && this.entity.targetDistance < 16.0f && this.entity.targetDistance > 4.0f && (this.entity.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get()) && this.entity.m_217043_().m_188503_(3 - this.consecutive) == 0 || this.entity.m_217043_().m_188503_(10) == 0)) {
                ++this.consecutive;
                this.entity.playAnimation(EntityNamelessGuardian.POUNCE_ATTACK_ANIMATION_1);
            }
        }
    }

    public static Vec3 findTargetPoint(Entity attacker, Entity target) {
        Vec3 vec3 = target.m_20182_();
        return new Vec3(vec3.f_82479_ - attacker.m_20185_(), 0.0, vec3.f_82481_ - attacker.m_20189_()).m_82541_();
    }

    private boolean checkModeOrPreventTimeouts() {
        return this.entity.isChallengeMode() || this.entity.getMadnessTick() > 200 && this.entity.m_7090_();
    }
}

